﻿var serverStats = {
    context: $(".v-serverStatistics"),
    webspaceId: null,
    datatable: null,
    initializeDataTable: function (folder) {
        this.datatable = $(".h-serverStatisticsTable", this.context).a4datatable({
            advancedFilter: false,
            ajaxAction: a4.getAction("GetWebSpaceServerStatistics", "MultiMode", "Settings", { webspaceId: serverStats.webspaceId }),
            columns: [
                { "Title": resources.ServerName, "Data": "Name" },
                { "Title": resources.ProjectName, "Data": "ProjectName" },
                { "Title": resources.AvgResponseTime, "Data": "AvgResponseTime", "Type": "numeric" },
                { "Title": resources.MaxResponseTime, "Data": "MaxResponseTime", "Type": "numeric" },
                { "Title": resources.MaxConcurrentConnections, "Data": "MaxConcurrentConnections", "Type": "numeric" },
                { "Title": resources.RequestCount, "Data": "RequestCount", "Type": "numeric" },
                { "Title": resources.ConnectionCount, "Data": "ConnectionCount", "Type": "numeric" },
                { "Title": resources.AbnormalDisconnectionCount, "Data": "AbnormalDisconnectionCount", "Type": "numeric" },
                { "Title": resources.RejectedConnectionCount, "Data": "RejectedConnectionCount", "Type": "numeric" },
                { "Title": resources.ErrorCount, "Data": "ErrorCount", "Type": "numeric" }
            ],
            stateKey: "ServerStats",
            quickFilter: {
                "Items": [
                    { "Label": resources.Today, "AjaxParams": { "period": "today" } },
                    { "Label": resources.ThisWeek, "AjaxParams": { "period": "week" } },
                    { "Label": resources.ThisMonth, "AjaxParams": { "period": "month" } },
                    { "Label": resources.Custom, "AjaxParams": { "period": "custom" }, "CustomInputs": [{ "Label": resources.From, "Type": "date", "Key": "period_from" }, { "Label": resources.To, "Type": "date", "Key": "period_to" }] }
                ]
            }
        });
    }
}

$(document).ready(function () {
    if (serverStats.context.length > 0) {
        serverStats.webspaceId = $("#WebSpaceId", serverStats.context).val();
        serverStats.initializeDataTable();
    }
});